<?php $__env->startSection('content'); ?>
<div class="row mb-3">
  <div class="col-md-12">
    <div class="card">
      <div class="card-header pb-0">
        <h6>Daftar Task</h6>
      </div>
      <div class="card-body">
        <form method="GET" action="<?php echo e(route('tasks.index')); ?>" class="row g-3">
          <div class="col-md-2">
            <label class="form-label">Status</label>
            <select class="form-control" name="status">
              <option value="">Semua</option>
              <option value="Tersampaikan" <?php echo e(request('status')=='Tersampaikan'?'selected':''); ?>>Tersampaikan</option>
              <option value="Sedang Dikerjakan" <?php echo e(request('status')=='Sedang Dikerjakan'?'selected':''); ?>>Sedang Dikerjakan</option>
              <option value="Selesai" <?php echo e(request('status')=='Selesai'?'selected':''); ?>>Selesai</option>
            </select>
          </div>
          <div class="col-md-2">
            <label class="form-label">Jenis</label>
            <select class="form-control" name="type">
              <option value="">Semua</option>
              <?php $__currentLoopData = ['SA','DB','FE','BE','SI','AS']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <option value="<?php echo e($type); ?>" <?php echo e(request('type')==$type ? 'selected' : ''); ?>><?php echo e($type); ?></option>
              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
          </div>
          <div class="col-md-2">
            <label class="form-label">Bulan</label>
            <input type="month" class="form-control" name="month" value="<?php echo e(request('month')); ?>">
          </div>
          <div class="col-md-3">
            <label class="form-label">Cari</label>
            <input type="text" class="form-control" name="q" value="<?php echo e(request('q')); ?>" placeholder="Nama, Email, Status...">
          </div>
          <div class="col-md-3 d-flex align-items-end justify-content-md-end gap-2 flex-wrap">
            <button class="btn bg-gradient-primary btn-sm mb-0" type="submit">Filter</button>
            <a href="<?php echo e(route('tasks.index')); ?>" class="btn btn-outline-secondary btn-sm mb-0">Reset</a>
          </div>
        </form>
      </div>
    </div>
  </div>
</div>

<div class="row">
  <div class="col-md-12">
    <div class="card">
      <div class="card-header pb-0 px-3">
        <div class="d-flex justify-content-end gap-2">
          <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('manage-tasks')): ?>
          <a href="<?php echo e(route('tasks.create')); ?>" class="btn bg-gradient-success btn-sm mb-0">Tambah Task</a>
          <?php endif; ?>
          <a href="<?php echo e(route('tasks.export', request()->only(['status','type','month','q']))); ?>" class="btn btn-outline-primary btn-sm mb-0" data-confirm="Export XLSX sekarang?">Export XLSX</a>
        </div>
      </div>
      <div class="card-body px-0 pb-2">
        <div class="table-responsive">
          <table class="table table-striped table-hover align-items-center mb-0">
            <thead>
              <tr>
                <th class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">Task</th>
                <th class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">Status</th>
                <th class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">Target</th>
                <th class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">Aksi</th>
              </tr>
            </thead>
            <tbody>
              <?php $__empty_1 = true; $__currentLoopData = $tasks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $task): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <tr>
                  <td>
                    <div class="d-flex flex-column">
                      <span class="text-sm font-weight-bold"><?php echo e($task->name); ?></span>
                      <?php if($task->link_gitlab): ?>
                        <a href="<?php echo e($task->link_gitlab); ?>" target="_blank" class="text-xs text-primary mt-1 d-block"><i class="fas fa-external-link-alt me-1"></i> Go to URL</a>
                      <?php endif; ?>
                      <div class="mt-1">
                    <?php $__currentLoopData = ($task->types ?? []); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                      <span class="badge badge-sm bg-gradient-info me-1"><?php echo e($type); ?></span>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                      </div>
                      <div class="mt-2 text-xs text-secondary">
                        <i class="ni ni-time-alarm"></i> <?php echo e($task->reminder_frequency_hours); ?> jam
                        <span class="ms-2"><i class="ni ni-email-83"></i> <?php echo e(implode(', ', $task->reminder_emails ?? ($task->reminder_email ? [$task->reminder_email] : []))); ?></span>
                      </div>
                      <div class="text-xxs text-secondary">
                        Terakhir: <?php echo e($task->last_reminded_at ? \Illuminate\Support\Carbon::parse($task->last_reminded_at)->format('d M Y H:i') : '-'); ?>

                        <span class="ms-2">Dicatat: <?php echo e($task->recorded_at ? \Illuminate\Support\Carbon::parse($task->recorded_at)->format('d M Y') : \Illuminate\Support\Carbon::parse($task->created_at)->format('d M Y')); ?></span>
                      </div>
                    </div>
                  </td>
                  <td>
                    <?php
                      $statusColor = $task->status === 'Selesai' ? 'success' : ($task->status === 'Sedang Dikerjakan' ? 'warning' : 'secondary');
                    ?>
                    <span class="badge badge-sm bg-gradient-<?php echo e($statusColor); ?>"><?php echo e($task->status); ?></span>
                  </td>
                  <td><?php echo e(\Illuminate\Support\Carbon::parse($task->target_date)->format('d M Y')); ?></td>
                  <td>
                    <a href="<?php echo e(route('tasks.show', $task)); ?>" class="btn btn-sm bg-gradient-info me-2">Detail</a>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('manage-tasks')): ?>
                    <a href="<?php echo e(route('tasks.edit', $task)); ?>" class="btn btn-sm bg-gradient-primary">Edit</a>
                    <?php endif; ?>
                  </td>
                </tr>
              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <tr>
                  <td colspan="9" class="text-center text-secondary">Tidak ada data.</td>
                </tr>
              <?php endif; ?>
            </tbody>
          </table>
        </div>
        <div class="px-3 mt-3 d-flex justify-content-end">
          <?php echo e($tasks->links()); ?>

        </div>
      </div>
    </div>
  </div>
</div>
<style>
.pagination .page-link {
  border-radius: .5rem;
}
</style>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.user_type.auth', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Users/tryprasetyoadi/Documents/cubi/soft-ui-dashboard-laravel/resources/views/tasks/index.blade.php ENDPATH**/ ?>