<?php $__env->startSection('content'); ?>
<div class="row">
  <div class="col-md-12">
    <div class="card">
      <div class="card-header pb-0 px-3">
        <div class="d-flex justify-content-between align-items-center mb-3">
            <h6>Daftar Link Penting</h6>
            <a href="<?php echo e(route('important-links.create')); ?>" class="btn bg-gradient-success btn-sm mb-0">Tambah Link</a>
        </div>
        <form method="GET" action="<?php echo e(route('important-links.index')); ?>" class="row g-3">
            <div class="col-md-4">
                <div class="input-group">
                    <span class="input-group-text text-body"><i class="fas fa-search" aria-hidden="true"></i></span>
                    <input type="text" class="form-control" name="q" value="<?php echo e(request('q')); ?>" placeholder="Cari nama atau link...">
                </div>
            </div>
            <div class="col-md-2">
                <button type="submit" class="btn bg-gradient-primary mb-0">Cari</button>
            </div>
        </form>
      </div>
      <div class="card-body px-0 pb-2">
        <?php if(session('success')): ?>
        <div class="alert alert-success mx-3 text-white">
            <?php echo e(session('success')); ?>

        </div>
        <?php endif; ?>
        <div class="table-responsive">
          <table class="table table-striped table-hover align-items-center mb-0">
            <thead>
              <tr>
                <th class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">Nama</th>
                <th class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">Link</th>
                <th class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">Aksi</th>
              </tr>
            </thead>
            <tbody>
              <?php $__empty_1 = true; $__currentLoopData = $links; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $link): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <tr>
                  <td class="px-4">
                    <span class="text-sm font-weight-bold"><?php echo e($link->name); ?></span>
                  </td>
                  <td>
                    <a href="<?php echo e($link->link); ?>" target="_blank" class="text-sm text-primary"><?php echo e(Str::limit($link->link, 50)); ?> <i class="fas fa-external-link-alt ms-1 text-xs"></i></a>
                  </td>
                  <td>
                    <a href="<?php echo e(route('important-links.edit', $link->id)); ?>" class="btn btn-sm bg-gradient-primary me-2">Edit</a>
                    <form action="<?php echo e(route('important-links.destroy', $link->id)); ?>" method="POST" class="d-inline" onsubmit="return confirm('Apakah Anda yakin ingin menghapus link ini?');">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('DELETE'); ?>
                        <button type="submit" class="btn btn-sm bg-gradient-danger">Hapus</button>
                    </form>
                  </td>
                </tr>
              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <tr>
                  <td colspan="3" class="text-center text-secondary py-4">Tidak ada data link penting.</td>
                </tr>
              <?php endif; ?>
            </tbody>
          </table>
        </div>
        <div class="px-3 mt-3 d-flex justify-content-end">
          <?php echo e($links->links()); ?>

        </div>
      </div>
    </div>
  </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.user_type.auth', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Users/tryprasetyoadi/Documents/cubi/soft-ui-dashboard-laravel/resources/views/important-links/index.blade.php ENDPATH**/ ?>