@extends('layouts.user_type.auth')

@section('content')
<div class="row mb-3">
  <div class="col-md-12">
    <div class="card">
      <div class="card-header pb-0">
        <h6>Daftar Task</h6>
      </div>
      <div class="card-body">
        <form method="GET" action="{{ route('tasks.index') }}" class="row g-3">
          <div class="col-md-2">
            <label class="form-label">Status</label>
            <select class="form-control" name="status">
              <option value="">Semua</option>
              <option value="Tersampaikan" {{ request('status')=='Tersampaikan'?'selected':'' }}>Tersampaikan</option>
              <option value="Sedang Dikerjakan" {{ request('status')=='Sedang Dikerjakan'?'selected':'' }}>Sedang Dikerjakan</option>
              <option value="Selesai" {{ request('status')=='Selesai'?'selected':'' }}>Selesai</option>
            </select>
          </div>
          <div class="col-md-2">
            <label class="form-label">Jenis</label>
            <select class="form-control" name="type">
              <option value="">Semua</option>
              @foreach(['SA','DB','FE','BE','SI','AS'] as $type)
                <option value="{{ $type }}" {{ request('type')==$type ? 'selected' : '' }}>{{ $type }}</option>
              @endforeach
            </select>
          </div>
          <div class="col-md-2">
            <label class="form-label">Bulan</label>
            <input type="month" class="form-control" name="month" value="{{ request('month') }}">
          </div>
          <div class="col-md-3">
            <label class="form-label">Cari</label>
            <input type="text" class="form-control" name="q" value="{{ request('q') }}" placeholder="Nama, Email, Status...">
          </div>
          <div class="col-md-3 d-flex align-items-end justify-content-md-end gap-2 flex-wrap">
            <button class="btn bg-gradient-primary btn-sm mb-0" type="submit">Filter</button>
            <a href="{{ route('tasks.index') }}" class="btn btn-outline-secondary btn-sm mb-0">Reset</a>
          </div>
        </form>
      </div>
    </div>
  </div>
</div>

<div class="row">
  <div class="col-md-12">
    <div class="card">
      <div class="card-header pb-0 px-3">
        <div class="d-flex justify-content-end gap-2">
          @can('manage-tasks')
          <a href="{{ route('tasks.create') }}" class="btn bg-gradient-success btn-sm mb-0">Tambah Task</a>
          @endcan
          <a href="{{ route('tasks.export', request()->only(['status','type','month','q'])) }}" class="btn btn-outline-primary btn-sm mb-0" data-confirm="Export XLSX sekarang?">Export XLSX</a>
        </div>
      </div>
      <div class="card-body px-0 pb-2">
        <div class="table-responsive">
          <table class="table table-striped table-hover align-items-center mb-0">
            <thead>
              <tr>
                <th class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">Task</th>
                <th class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">Status</th>
                <th class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">Target</th>
                <th class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">Aksi</th>
              </tr>
            </thead>
            <tbody>
              @forelse($tasks as $task)
                <tr>
                  <td>
                    <div class="d-flex flex-column">
                      <span class="text-sm font-weight-bold">{{ $task->name }}</span>
                      @if($task->link_gitlab)
                        <a href="{{ $task->link_gitlab }}" target="_blank" class="text-xs text-primary mt-1 d-block"><i class="fas fa-external-link-alt me-1"></i> Go to URL</a>
                      @endif
                      <div class="mt-1">
                    @foreach(($task->types ?? []) as $type)
                      <span class="badge badge-sm bg-gradient-info me-1">{{ $type }}</span>
                    @endforeach
                      </div>
                      <div class="mt-2 text-xs text-secondary">
                        <i class="ni ni-time-alarm"></i> {{ $task->reminder_frequency_hours }} jam
                        <span class="ms-2"><i class="ni ni-email-83"></i> {{ implode(', ', $task->reminder_emails ?? ($task->reminder_email ? [$task->reminder_email] : [])) }}</span>
                      </div>
                      <div class="text-xxs text-secondary">
                        Terakhir: {{ $task->last_reminded_at ? \Illuminate\Support\Carbon::parse($task->last_reminded_at)->format('d M Y H:i') : '-' }}
                        <span class="ms-2">Dicatat: {{ $task->recorded_at ? \Illuminate\Support\Carbon::parse($task->recorded_at)->format('d M Y') : \Illuminate\Support\Carbon::parse($task->created_at)->format('d M Y') }}</span>
                      </div>
                    </div>
                  </td>
                  <td>
                    @php
                      $statusColor = $task->status === 'Selesai' ? 'success' : ($task->status === 'Sedang Dikerjakan' ? 'warning' : 'secondary');
                    @endphp
                    <span class="badge badge-sm bg-gradient-{{ $statusColor }}">{{ $task->status }}</span>
                  </td>
                  <td>{{ \Illuminate\Support\Carbon::parse($task->target_date)->format('d M Y') }}</td>
                  <td>
                    <a href="{{ route('tasks.show', $task) }}" class="btn btn-sm bg-gradient-info me-2">Detail</a>
                    @can('manage-tasks')
                    <a href="{{ route('tasks.edit', $task) }}" class="btn btn-sm bg-gradient-primary">Edit</a>
                    @endcan
                  </td>
                </tr>
              @empty
                <tr>
                  <td colspan="9" class="text-center text-secondary">Tidak ada data.</td>
                </tr>
              @endforelse
            </tbody>
          </table>
        </div>
        <div class="px-3 mt-3 d-flex justify-content-end">
          {{ $tasks->links() }}
        </div>
      </div>
    </div>
  </div>
</div>
<style>
.pagination .page-link {
  border-radius: .5rem;
}
</style>
@endsection
