@extends('layouts.user_type.auth')

@section('content')
<div class="row">
  <div class="col-xl-4 col-md-6 mb-4">
    <div class="card">
      <div class="card-header pb-0">
        <h6>Ringkasan Status Task</h6>
      </div>
      <div class="card-body">
        <canvas id="statusChart" height="200"></canvas>
      </div>
    </div>
  </div>
  <div class="col-xl-4 col-md-6 mb-4">
    <div class="card">
      <div class="card-header pb-0">
        <h6>Distribusi Jenis Task</h6>
      </div>
      <div class="card-body">
        <canvas id="typeChart" height="200"></canvas>
      </div>
    </div>
  </div>
  <div class="col-xl-4 col-md-12 mb-4">
    <div class="card">
      <div class="card-header pb-0">
        <h6>Rekap Task Bulanan</h6>
      </div>
      <div class="card-body">
        <canvas id="monthlyChart" height="200"></canvas>
      </div>
    </div>
  </div>
</div>

<div class="row">
  <div class="col-md-12">
    <div class="card">
      <div class="card-header pb-0">
        <h6>Task Mendekati Target Date</h6>
      </div>
      <div class="card-body px-0 pb-2">
        <div id="task-dashboard-data"
             data-status="{{ base64_encode(json_encode($statusCounts)) }}"
             data-type="{{ base64_encode(json_encode($typeCounts)) }}"
             data-months="{{ base64_encode(json_encode($months)) }}"
             data-monthcounts="{{ base64_encode(json_encode($monthCounts)) }}"></div>
        <div class="table-responsive">
          <table class="table align-items-center mb-0">
            <thead>
              <tr>
                <th class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">Nama Task</th>
                <th class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">Status</th>
                <th class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">Target Date</th>
                <th class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">Jenis</th>
              </tr>
            </thead>
            <tbody>
              @forelse($nearDueTasks as $t)
                <tr>
                  <td>{{ $t->name }}</td>
                  <td>{{ $t->status }}</td>
                  <td>{{ \Illuminate\Support\Carbon::parse($t->target_date)->format('d M Y') }}</td>
                  <td>{{ implode(', ', $t->types ?? []) }}</td>
                </tr>
              @empty
                <tr>
                  <td colspan="4" class="text-center text-secondary">Tidak ada task mendekati target date.</td>
                </tr>
              @endforelse
            </tbody>
          </table>
        </div>
      </div>
    </div>
  </div>
</div>

<div class="row">
  <div class="col-md-12">
    <div class="card">
      <div class="card-header pb-0">
        <h6>Task Overdue</h6>
      </div>
      <div class="card-body px-0 pb-2">
        <div class="table-responsive">
          <table class="table align-items-center mb-0">
            <thead>
              <tr>
                <th class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">Nama Task</th>
                <th class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">Status</th>
                <th class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">Target Date</th>
                <th class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">Overdue (hari)</th>
                <th class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">Jenis</th>
              </tr>
            </thead>
            <tbody>
              @forelse($overdueTasks as $t)
                <tr>
                  <td>{{ $t->name }}</td>
                  <td>{{ $t->status }}</td>
                  <td>{{ \Illuminate\Support\Carbon::parse($t->target_date)->format('d M Y') }}</td>
                  <td>{{ \Illuminate\Support\Carbon::parse($t->target_date)->diffInDays(\Illuminate\Support\Carbon::today()) }}</td>
                  <td>{{ implode(', ', $t->types ?? []) }}</td>
                </tr>
              @empty
                <tr>
                  <td colspan="5" class="text-center text-secondary">Tidak ada task overdue.</td>
                </tr>
              @endforelse
            </tbody>
          </table>
        </div>
      </div>
    </div>
  </div>
</div>

@push('dashboard')
<script>
  const el = document.getElementById('task-dashboard-data');
  const statusData = JSON.parse(atob(el.dataset.status));
  const typeData = JSON.parse(atob(el.dataset.type));
  const months = JSON.parse(atob(el.dataset.months));
  const monthCounts = JSON.parse(atob(el.dataset.monthcounts));

  const statusCtx = document.getElementById('statusChart').getContext('2d');
  new Chart(statusCtx, {
    type: 'doughnut',
    data: {
      labels: ['Tersampaikan', 'Sedang Dikerjakan', 'Selesai'],
      datasets: [{
        data: [statusData['Tersampaikan'], statusData['Sedang Dikerjakan'], statusData['Selesai']],
        backgroundColor: ['#fbcf33', '#3A416F', '#2DCE89']
      }]
    },
    options: { responsive: true, maintainAspectRatio: false }
  });

  const typeCtx = document.getElementById('typeChart').getContext('2d');
  new Chart(typeCtx, {
    type: 'bar',
    data: {
      labels: ['SA','DB','FE','BE','SI','AS'],
      datasets: [{
        label: 'Jumlah',
        data: ['SA','DB','FE','BE','SI','AS'].map(k => typeData[k]),
        backgroundColor: '#17C1E8'
      }]
    },
    options: { responsive: true, maintainAspectRatio: false }
  });

  const monthlyCtx = document.getElementById('monthlyChart').getContext('2d');
  new Chart(monthlyCtx, {
    type: 'line',
    data: {
      labels: months,
      datasets: [{
        label: 'Task per Bulan',
        data: monthCounts,
        borderColor: '#fbcf33',
        backgroundColor: 'rgba(251, 207, 51, 0.2)',
        tension: 0.4
      }]
    },
    options: { responsive: true, maintainAspectRatio: false }
  });
</script>
@endpush
@endsection
