@extends('layouts.user_type.auth')

@section('content')
<div class="row">
  <div class="col-md-8 mx-auto">
    <div class="card">
      <div class="card-header pb-0">
        <h6>Detail Reminder Stakeholder</h6>
      </div>
      <div class="card-body">
        <div class="mb-3">
          <strong>Judul:</strong> {{ $item->name }}
        </div>
        <div class="mb-3">
          <strong>Status:</strong> {{ $item->status }}
        </div>
        <div class="mb-3">
          <strong>Target Date:</strong> {{ \Illuminate\Support\Carbon::parse($item->target_date)->format('d M Y') }}
        </div>
        <div class="mb-3">
          <strong>Reminder To:</strong> {{ $item->reminder_to }}
        </div>
        <div class="mb-3">
          <strong>Frekuensi Reminder (jam):</strong> {{ $item->reminder_frequency_hours }}
        </div>
        <div class="mb-3">
          <strong>Email Tujuan Reminder:</strong> {{ implode(', ', $item->reminder_emails ?? []) }}
        </div>
        <div class="mb-3">
          <strong>Terakhir Reminder:</strong> {{ $item->last_reminded_at ? \Illuminate\Support\Carbon::parse($item->last_reminded_at)->format('d M Y H:i') : '-' }}
        </div>
        <div class="mb-3">
          <strong>Tanggal Pencatatan:</strong> {{ $item->recorded_at ? \Illuminate\Support\Carbon::parse($item->recorded_at)->format('d M Y') : \Illuminate\Support\Carbon::parse($item->created_at)->format('d M Y') }}
        </div>
        <div class="d-flex justify-content-end">
          <a href="{{ route('stakeholders.index') }}" class="btn btn-light">Kembali</a>
          <a href="{{ route('stakeholders.edit', $item) }}" class="btn btn-primary ms-2" data-confirm="Masuk ke halaman edit reminder?">Edit</a>
        </div>
      </div>
    </div>
  </div>
@endsection
