@extends('layouts.user_type.auth')

@section('content')
<div class="row">
  <div class="col-md-12">
    <div class="card">
      <div class="card-header pb-0 px-3">
        <div class="d-flex justify-content-between align-items-center mb-3">
            <h6>Daftar Link Penting</h6>
            <a href="{{ route('important-links.create') }}" class="btn bg-gradient-success btn-sm mb-0">Tambah Link</a>
        </div>
        <form method="GET" action="{{ route('important-links.index') }}" class="row g-3">
            <div class="col-md-4">
                <div class="input-group">
                    <span class="input-group-text text-body"><i class="fas fa-search" aria-hidden="true"></i></span>
                    <input type="text" class="form-control" name="q" value="{{ request('q') }}" placeholder="Cari nama atau link...">
                </div>
            </div>
            <div class="col-md-2">
                <button type="submit" class="btn bg-gradient-primary mb-0">Cari</button>
            </div>
        </form>
      </div>
      <div class="card-body px-0 pb-2">
        @if(session('success'))
        <div class="alert alert-success mx-3 text-white">
            {{ session('success') }}
        </div>
        @endif
        <div class="table-responsive">
          <table class="table table-striped table-hover align-items-center mb-0">
            <thead>
              <tr>
                <th class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">Nama</th>
                <th class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">Link</th>
                <th class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">Aksi</th>
              </tr>
            </thead>
            <tbody>
              @forelse($links as $link)
                <tr>
                  <td class="px-4">
                    <span class="text-sm font-weight-bold">{{ $link->name }}</span>
                  </td>
                  <td>
                    <a href="{{ $link->link }}" target="_blank" class="text-sm text-primary">{{ Str::limit($link->link, 50) }} <i class="fas fa-external-link-alt ms-1 text-xs"></i></a>
                  </td>
                  <td>
                    <a href="{{ route('important-links.edit', $link->id) }}" class="btn btn-sm bg-gradient-primary me-2">Edit</a>
                    <form action="{{ route('important-links.destroy', $link->id) }}" method="POST" class="d-inline" onsubmit="return confirm('Apakah Anda yakin ingin menghapus link ini?');">
                        @csrf
                        @method('DELETE')
                        <button type="submit" class="btn btn-sm bg-gradient-danger">Hapus</button>
                    </form>
                  </td>
                </tr>
              @empty
                <tr>
                  <td colspan="3" class="text-center text-secondary py-4">Tidak ada data link penting.</td>
                </tr>
              @endforelse
            </tbody>
          </table>
        </div>
        <div class="px-3 mt-3 d-flex justify-content-end">
          {{ $links->links() }}
        </div>
      </div>
    </div>
  </div>
</div>
@endsection
