@extends('layouts.user_type.auth')

@section('content')
<div class="row">
  <div class="col-md-8 mx-auto">
    <div class="card">
      <div class="card-header pb-0">
        <h6>Tambah Link Penting</h6>
      </div>
      <div class="card-body">
        <form method="POST" action="{{ route('important-links.store') }}">
          @csrf
          <div class="mb-3">
            <label class="form-label">Nama</label>
            <input type="text" class="form-control" name="name" value="{{ old('name') }}" required>
            @error('name') <small class="text-danger">{{ $message }}</small> @enderror
          </div>
          <div class="mb-3">
            <label class="form-label">Link</label>
            <input type="url" class="form-control" name="link" value="{{ old('link') }}" placeholder="https://..." required>
            @error('link') <small class="text-danger">{{ $message }}</small> @enderror
          </div>
          <div class="d-flex justify-content-end">
            <a href="{{ route('important-links.index') }}" class="btn btn-light me-2">Batal</a>
            <button type="submit" class="btn btn-primary">Simpan</button>
          </div>
        </form>
      </div>
    </div>
  </div>
</div>
@endsection
