<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('tasks', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->date('target_date');
            $table->json('types')->nullable();
            $table->enum('status', ['Tersampaikan', 'Sedang Dikerjakan', 'Selesai'])->default('Tersampaikan');
            $table->unsignedInteger('reminder_frequency_hours')->default(24);
            $table->string('reminder_email');
            $table->timestamp('last_reminded_at')->nullable();
            $table->date('recorded_at')->nullable();
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('tasks');
    }
};

