<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Carbon;

class Task extends Model
{
    use HasFactory;

    protected $fillable = [
        'name',
        'target_date',
        'types',
        'status',
        'link_gitlab',
        'reminder_frequency_hours',
        'reminder_email',
        'reminder_emails',
        'last_reminded_at',
        'recorded_at',
    ];

    protected $casts = [
        'types' => 'array',
        'target_date' => 'date',
        'last_reminded_at' => 'datetime',
        'recorded_at' => 'date',
        'reminder_emails' => 'array',
    ];

    protected static function booted(): void
    {
        static::creating(function (Task $task) {
            if (empty($task->status)) {
                $task->status = 'Tersampaikan';
            }
            if (empty($task->recorded_at)) {
                $task->recorded_at = Carbon::now()->toDateString();
            }
        });
    }

    public function isCompleted(): bool
    {
        return $this->status === 'Selesai';
    }
}
